import { Button } from '@/components/ui/button';
import Link from 'next/link';
import { ArrowRight, Code, Cpu, Database, Smartphone, Briefcase, Globe, Shield, Rocket } from 'lucide-react';
import ContactForm from '@/components/contact-form';

export default function Home() {
  const features = [
    {
      icon: <Code className="h-8 w-8 text-primary" />,
      title: 'Custom Software',
      description: 'Tailored solutions designed specifically for your business needs and goals.'
    },
    {
      icon: <Smartphone className="h-8 w-8 text-primary" />,
      title: 'Mobile Apps',
      description: 'Engaging mobile experiences that connect you with your customers.'
    },
    {
      icon: <Cpu className="h-8 w-8 text-primary" />,
      title: 'AI Solutions',
      description: 'Leverage the power of artificial intelligence to transform your business.'
    },
    {
      icon: <Database className="h-8 w-8 text-primary" />,
      title: 'Cloud Services',
      description: 'Scalable and secure cloud solutions for your growing business.'
    },
  ];

  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="pt-24 pb-16 md:pt-32 md:pb-24 relative overflow-hidden">
        <div className="absolute inset-0 -z-10">
          <div className="absolute inset-0 bg-gradient-to-b from-background to-background/80" />
          <div className="absolute inset-0 bg-[radial-gradient(circle_at_center,_var(--tw-gradient-stops))] from-primary/10 via-background to-background" />
        </div>
        
        <div className="container px-4 mx-auto relative">
          <div className="max-w-3xl mx-auto text-center">
            <h1 className="text-4xl md:text-6xl font-bold tracking-tight bg-clip-text text-transparent bg-gradient-to-r from-foreground to-foreground/70">
              Transforming Ideas Into
              <span className="bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent"> Digital Reality</span>
            </h1>
            <p className="mt-6 text-lg text-muted-foreground max-w-2xl mx-auto">
              We craft exceptional digital experiences that drive growth and innovation for businesses worldwide.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center mt-8">
              <Button size="lg" className="group">
                Get Started
                <ArrowRight className="ml-2 h-4 w-4 group-hover:translate-x-1 transition-transform" />
              </Button>
              <Button variant="outline" size="lg">
                View Our Work
              </Button>
            </div>
          </div>
        </div>

        {/* Features Grid */}
        <div className="container px-4 mx-auto mt-16 md:mt-24">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {features.map((feature, index) => (
              <div 
                key={index}
                className="p-6 rounded-xl bg-background/50 border border-border/20 backdrop-blur-sm hover:shadow-lg transition-all hover:-translate-y-1"
              >
                <div className="bg-primary/10 w-14 h-14 rounded-lg flex items-center justify-center mb-4">
                  {feature.icon}
                </div>
                <h3 className="text-lg font-semibold mb-2">{feature.title}</h3>
                <p className="text-sm text-muted-foreground">{feature.description}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section id="services" className="py-16 md:py-24">
        <div className="container px-4 mx-auto">
          <div className="max-w-2xl mx-auto text-center mb-12">
            <span className="inline-block px-3 py-1 text-sm font-medium rounded-full bg-primary/10 text-primary mb-3">
              What We Do
            </span>
            <h2 className="text-3xl md:text-4xl font-bold tracking-tight">Our Services</h2>
            <p className="text-muted-foreground mt-3">End-to-end solutions from discovery to deployment.</p>
          </div>
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
            {[{
              icon: <Briefcase className="h-6 w-6 text-primary" />, title: 'Product Strategy', desc: 'Discovery, roadmapping, and delivery planning.'
            }, {
              icon: <Globe className="h-6 w-6 text-primary" />, title: 'Web Apps', desc: 'Robust, accessible, SEO-friendly applications.'
            }, {
              icon: <Shield className="h-6 w-6 text-primary" />, title: 'Security & QA', desc: 'Best practices, audits, and automated testing.'
            }, {
              icon: <Rocket className="h-6 w-6 text-primary" />, title: 'DevOps & Cloud', desc: 'CI/CD, observability, and scalable infra.'
            }, {
              icon: <Smartphone className="h-6 w-6 text-primary" />, title: 'Mobile Development', desc: 'iOS/Android using native or cross‑platform.'
            }, {
              icon: <Cpu className="h-6 w-6 text-primary" />, title: 'AI Integration', desc: 'LLMs, automation, and custom ML models.'
            }].map((s, i) => (
              <div key={i} className="p-6 rounded-xl border bg-card text-card-foreground shadow-sm hover:shadow-md transition-shadow">
                <div className="w-12 h-12 rounded-lg bg-primary/10 flex items-center justify-center mb-4">
                  {s.icon}
                </div>
                <h3 className="text-lg font-semibold">{s.title}</h3>
                <p className="text-sm text-muted-foreground mt-2">{s.desc}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* About Section */}
      <section id="about" className="py-16 md:py-24 bg-muted/30">
        <div className="container px-4 mx-auto">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div>
              <span className="inline-block px-3 py-1 text-sm font-medium rounded-full bg-primary/10 text-primary mb-4">
                About Us
              </span>
              <h2 className="text-3xl md:text-4xl font-bold tracking-tight mb-6">
                We're More Than Just a Software Company
              </h2>
              <p className="text-muted-foreground mb-6">
                At Arad Software, we believe in the power of technology to transform businesses and create meaningful impact. 
                Our team of passionate developers, designers, and strategists work together to deliver exceptional digital solutions.
              </p>
              <div className="space-y-4">
                <div className="flex items-start">
                  <div className="flex-shrink-0 mt-1">
                    <div className="flex items-center justify-center h-5 w-5 rounded-full bg-primary/10 text-primary">
                      <svg className="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                      </svg>
                    </div>
                  </div>
                  <p className="ml-3 text-sm text-muted-foreground">
                    <span className="font-medium text-foreground">10+ Years</span> of industry experience
                  </p>
                </div>
                <div className="flex items-start">
                  <div className="flex-shrink-0 mt-1">
                    <div className="flex items-center justify-center h-5 w-5 rounded-full bg-primary/10 text-primary">
                      <svg className="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                      </svg>
                    </div>
                  </div>
                  <p className="ml-3 text-sm text-muted-foreground">
                    <span className="font-medium text-foreground">200+ Projects</span> successfully delivered
                  </p>
                </div>
                <div className="flex items-start">
                  <div className="flex-shrink-0 mt-1">
                    <div className="flex items-center justify-center h-5 w-5 rounded-full bg-primary/10 text-primary">
                      <svg className="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                      </svg>
                    </div>
                  </div>
                  <p className="ml-3 text-sm text-muted-foreground">
                    <span className="font-medium text-foreground">98% Client</span> satisfaction rate
                  </p>
                </div>
              </div>
              <Button className="mt-8" asChild>
                <Link href="#contact">
                  Learn More About Us
                  <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </Button>
            </div>
            <div className="relative">
              <div className="relative rounded-2xl overflow-hidden aspect-[4/5] w-full max-w-lg mx-auto">
                <div className="absolute inset-0 bg-gradient-to-br from-primary/20 to-accent/20 rounded-2xl -rotate-6 scale-90"></div>
                <div className="absolute inset-0 bg-gradient-to-tl from-primary/20 to-accent/20 rounded-2xl rotate-6 scale-90"></div>
                <div className="relative h-full w-full bg-muted rounded-2xl overflow-hidden">
                  <div className="absolute inset-0 bg-[url('/images/team-working.jpg')] bg-cover bg-center opacity-30"></div>
                  <div className="absolute inset-0 flex items-center justify-center">
                    <div className="text-center p-6">
                      <div className="inline-flex items-center justify-center w-16 h-16 rounded-full bg-primary/10 text-primary mb-4">
                        <svg className="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 10V3L4 14h7v7l9-11h-7z" />
                        </svg>
                      </div>
                      <h3 className="text-xl font-semibold mb-2">Our Team</h3>
                      <p className="text-sm text-muted-foreground">Dedicated professionals passionate about innovation</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Portfolio Section */}
      <section id="portfolio" className="py-16 md:py-24">
        <div className="container px-4 mx-auto">
          <div className="max-w-2xl mx-auto text-center mb-12">
            <span className="inline-block px-3 py-1 text-sm font-medium rounded-full bg-primary/10 text-primary mb-3">
              Our Work
            </span>
            <h2 className="text-3xl md:text-4xl font-bold tracking-tight">Selected Projects</h2>
            <p className="text-muted-foreground mt-3">A glimpse into products we have recently delivered.</p>
          </div>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {[1,2,3,4,5,6].map((n) => (
              <div key={n} className="group relative rounded-xl overflow-hidden border bg-card">
                <div className="aspect-video bg-muted" />
                <div className="p-4">
                  <h3 className="font-semibold">Project {n}</h3>
                  <p className="text-sm text-muted-foreground">Web application • 2025</p>
                </div>
                <div className="absolute inset-0 ring-1 ring-border/40 pointer-events-none group-hover:ring-primary/40 transition" />
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section id="contact" className="py-16 md:py-24 bg-muted/30">
        <div className="container px-4 mx-auto">
          <div className="grid lg:grid-cols-2 gap-10 items-start">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold tracking-tight">Let’s build something great</h2>
              <p className="text-muted-foreground mt-3">
                Tell us about your goals and we’ll reach out to craft the ideal solution for your business.
              </p>
              <ul className="mt-6 space-y-3 text-sm text-muted-foreground">
                <li>• Response within 1 business day</li>
                <li>• NDA available upon request</li>
                <li>• Flexible engagement models</li>
              </ul>
            </div>
            <ContactForm />
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 md:py-24 bg-gradient-to-r from-primary to-accent text-primary-foreground">
        <div className="container px-4 mx-auto text-center">
          <h2 className="text-3xl md:text-4xl font-bold tracking-tight mb-6">
            Ready to Start Your Project?
          </h2>
          <p className="text-lg text-primary-foreground/90 max-w-2xl mx-auto mb-8">
            Let's discuss how we can help you achieve your business goals with our custom software solutions.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" variant="secondary" className="group">
              Get a Free Quote
              <ArrowRight className="ml-2 h-4 w-4 group-hover:translate-x-1 transition-transform" />
            </Button>
            <Button size="lg" variant="outline" className="text-primary-foreground border-primary-foreground/20 hover:bg-primary-foreground/10">
              Contact Us
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}
