import Link from 'next/link';

export default function NotFound() {
  return (
    <section className="min-h-[60vh] flex items-center">
      <div className="container px-4 mx-auto text-center">
        <h1 className="text-4xl md:text-5xl font-bold">Page not found</h1>
        <p className="mt-3 text-muted-foreground">The page you are looking for doesn’t exist or was moved.</p>
        <div className="mt-6">
          <Link href="/" className="inline-flex items-center px-4 py-2 rounded-md border bg-card hover:bg-accent/10">
            Go back home
          </Link>
        </div>
      </div>
    </section>
  );
}
