import { NextResponse } from 'next/server';

export async function POST(req: Request) {
  try {
    const body = await req.json();
    const name = String(body?.name || '').trim();
    const email = String(body?.email || '').trim();
    const details = String(body?.details || body?.message || '').trim();

    if (!name || !email || !details) {
      return NextResponse.json(
        { error: 'Name, email, and project details are required.' },
        { status: 400 }
      );
    }

    // TODO: Integrate an email service (e.g., Resend, SendGrid) using API keys.
    // For now, we simply acknowledge the request.
    console.log('Contact submission:', { name, email, details });

    return NextResponse.json({ ok: true });
  } catch (err) {
    return NextResponse.json({ error: 'Invalid request payload.' }, { status: 400 });
  }
}
