# Arad Software Company

Arad Software transforms ideas into digital reality. We craft custom web and mobile apps, AI solutions, and secure cloud systems. From strategy and UX to development, QA, and DevOps, we deliver scalable, accessible software and measurable results for businesses worldwide.

## Features
- Custom software development
- Web and mobile apps
- AI integration and automation
- Cloud services, DevOps, and CI/CD
- Security, QA, and best practices

## Tech Stack
- Next.js 13 (App Router), React 18, TypeScript
- Tailwind CSS, shadcn/ui patterns, lucide-react
- next-themes for dark/light mode
- Deployed on Netlify (see `netlify.toml`)

## Project Structure
- `app/` – routes, layout, global styles
- `components/` – UI components: `navbar`, `footer`, `ui/button`, `theme-provider`
- `lib/` – utilities and assets

## Getting Started
Prereqs: Node 18+ and npm.

```bash
# Install deps
npm install

# Run dev server
npm run dev

# Build for production
npm run build

# Start production server
npm run start

# Lint
npm run lint
```

## Deployment
- Netlify: push to your default branch; Netlify uses `next build`.
- Configure environment variables in Netlify dashboard if needed.

## SEO Metadata
Defined in `app/layout.tsx` (`metadata.title` and `metadata.description`).

## License
Proprietary © Arad Software Company. All rights reserved.
